#ifndef __DX_SIGN_APP_H__
#define __DX_SIGN_APP_H__

/* size of the EI_IDENT field in ELF */
#define EI_NIDENT                             16

/* the maximum size of modulus in bytes - 512 bytes = 2048 bits */
#define DX_MAX_PK_MODULUS_SIZE_IN_BYTES       256

/* the maximum size of exponent in bytes - 512 bytes = 2048 bits */
#define DX_MAX_PK_EXPONENT_SIZE_IN_BYTES      256

/* the maximum length of the caller id string */ 
#define DX_DM_CALLER_ID_STRING_LEN_IN_BYTES   60

/* the maximum length in bytes of the private data */
#define DX_DM_PRIVATE_DATA_LEN_IN_BYTES       4

/* length of signature in bytes */
#define DX_DM_SIGN_LEN_IN_BYTES               256

/* the type of discretix section */
#define DX_SIGN_SECTION_TYPE                  (0x80000000 + ('d' << 8) + 'x')

/* elf header struct */
typedef struct _elf_hdr_st{
  unsigned char   e_ident[EI_NIDENT];
  unsigned short  e_type;
  unsigned short  e_machine;
  unsigned long   e_version;
  unsigned long   e_entry;
  unsigned long   e_phoff;
  unsigned long   e_shoff;
  unsigned long   e_flags;
  unsigned short  e_ehsize;
  unsigned short  e_phentsize;
  unsigned short  e_phnum;
  unsigned short  e_shentsize;
  unsigned short  e_shnum;
  unsigned short  e_shtrndx;
}elf_hdr_st;


typedef struct 
{
  unsigned long p_type;
  unsigned long p_offset;
  unsigned long p_vaddr;
  unsigned long p_paddr;
  unsigned long p_filesz;
  unsigned long p_memsz;
  unsigned long p_flags;
  unsigned long p_align;
}elf32_phdr_st;

/* elf section header entry struct */
typedef struct _elf32_shdr_st
{
  unsigned long   sh_name;
  unsigned long   sh_type;
  unsigned long   sh_flags;
  unsigned long   sh_addr;
  unsigned long   sh_offset;
  unsigned long   sh_size;
  unsigned long   sh_link;
  unsigned long   sh_info;
  unsigned long   sh_addralign;
  unsigned long   sh_entsize;
}elf32_shdr_st;




/* the structure that defines a RSA public key */
typedef struct _dx_pk_st
{
  /* modulus size in bytes */
  unsigned long modulusSize;
  
  /* exponent size in bytes */
  unsigned long exponentSize;
  
  /* public key modulus */
  unsigned char modulus[DX_MAX_PK_MODULUS_SIZE_IN_BYTES];
  
  /* public key exponent */
  unsigned char exponent[DX_MAX_PK_EXPONENT_SIZE_IN_BYTES];
  
}dx_pk_st;



/* discretix application sign section structure */
typedef struct _dx_app_sign_section_st
{
  /* id of the section - reserved value */
  unsigned long section_id;
  
  /* caller id string */
  unsigned char caller_id[DX_DM_CALLER_ID_STRING_LEN_IN_BYTES]; 
  
  /* private data */
  unsigned long private_data;
  
  /* application public key */
  dx_pk_st      app_pk;
  
  /* number of authorized publick keys for DDLs authentication */
  unsigned long num_dll_pks;
  
}dx_app_sign_section_st;

/* dll sign section structure */
typedef struct _dx_dll_sign_section_st
{
  /* id of the section - reserved value */
  unsigned long section_id;
  
  /* DLL public key */
  dx_pk_st      dll_pk;
  
  /* signature size in bytes */
  unsigned long sign_size;
  
}dx_dll_sign_section_st;


#endif
